<?php
// #################################################
// #                                               #
// # vbAdvanced CMPS Block for ibProArcade v2.6.5+ #
// #                                               #
// # (C)opyright 2006 by MrZeropage                #
// #                                               #
// # This is compatible to:                        #
// # > ibProArcade v2.6.5+ or later                #
// # > vbAdvanced  v CMPS v3.0                     #
// # > vBulletin   v3.6.X  or later                #
// #                                               #
// #################################################

// ############################################
// ### HERE YOU HAVE TO ADAPT YOUR SETTINGS ###
// ############################################
global $vbulletin, $path, $largelimit, $maxcolumns,$phrase1, $phrase2, $db;

$largelimit 	= 2;				// max. of Rows per "Big Box", if more it will be "Small Box"

// you may translate the following for output
$text_new	= "newest Games";
$text_popular	= "most popular Games";
$text_rated	= "Top-Rated Games";
$text_random	= "Random Games";
$text_topx	= "Top Highscore-Champions";
$text_champs	= "Latest Highscore-Champions";
$text_scores	= "Latest Scores";
$phrase1	= "<%NAME%> scored <%SCORE%> playing <%GAME%>";
$phrase2	= "<%NAME%> is the new <%GAME%> Champion";

// ###########################################
// #  ! NO MODIFICATION BEYOND THIS POINT !  #
// ###########################################

// *************************************
// *** read settings from vbAdvanced ***
// *************************************
$games_new	= $mod_options['games_new'];
$games_popular	= $mod_options['games_popular'];
$games_rating	= $mod_options['games_rating'];
$games_rand 	= $mod_options['games_rand'];
$top_champs	= $mod_options['top_champs'];
$newchamps	= $mod_options['newchamps'];
$newscores	= $mod_options['newscores'];
$show_new	= $mod_options['show_games_new'];
$show_popular	= $mod_options['show_games_popular'];
$show_rating	= $mod_options['show_games_rating'];
$show_rand	= $mod_options['show_games_rand'];
$show_champs	= $mod_options['show_top_champs'];
$show_newchamps = $mod_options['show_newchamps'];
$show_newscores	= $mod_options['show_newscores'];
$maxcolumns	= $mod_options['maxcolumns'];

// ******************
// *** initialize ***
// ******************
$path		  = $vbulletin->options['bburl']."/arcade/images/";
$output_new 	  = "";
$output_popular	  = "";
$output_rating 	  = "";
$output_random 	  = "";
$output_top3	  = "";
$output_newscores = "";
$output_newchamps = "";

// *****************************************
// *** check/verify settings to be valid ***
// *****************************************
if (intval($games_new)     < 1) { $games_new     = 5; }
if (intval($games_popular) < 1) { $games_popular = 5; }
if (intval($games_rating)  < 1) { $games_rating  = 5; }
if (intval($games_rand)    < 1) { $games_rand    = 1; }
if (intval($top_champs)	   < 1) { $top_champs	 = 3; }
if (intval($newchamps)	   < 1) { $newchamps	 = 5; }
if (intval($newscores)	   < 1) { $newchamps	 = 5; }
if (intval($maxcolumns)    < 1) { $maxcolumns	 = 4; }

// *********************************
// *** generate active Gameboxes ***
// *********************************
if ($show_new) 		{ $output_new 		= getgames(1,$games_new,$text_new); }
if ($show_popular) 	{ $output_popular 	= getgames(2,$games_popular,$text_popular); }
if ($show_rating)	{ $output_rating  	= getgames(3,$games_rating,$text_rated); }
if ($show_rand)		{ $output_random  	= getgames(4,$games_rand,$text_random); }
if ($show_champs)	{ $output_top3 		= getscores(1,$text_topx,$top_champs); }
if ($show_newchamps)	{ $output_newchamps 	= getscores(2,$text_champs,$newchamps); }
if ($show_newscores)	{ $output_newscores 	= getscores(3,$text_scores,$newscores); }

// *********************************************
// *** build the fields                      ***
// *** (you may sort the order of the Boxes) ***
// *********************************************
$bigfield = ""; $big = 1;
$smallfield = ""; $small = 1;

// ########################################
// ### Latest Scores (always large Box) ###
// ########################################
if ($show_newscores)
{
	$bigfield .= newline($largelimit-1) . $output_newscores . newline($largelimit-1) . linebreak($big); $big++;
}

// ##################################################
// ### Latest Highscore-Champs (always large Box) ###
// ##################################################
if ($show_newchamps)
{
	$bigfield .= newline($largelimit-1) . $output_newchamps . newline($largelimit-1) . linebreak($big); $big++;
}

// #######################################
// ### Top x Champs (always small Box) ###
// #######################################
if ($show_champs)
{
	$smallfield .= $output_top3 . linebreak($small); $small++;
}

// ####################
// ### newest Games ###
// ####################
if ($games_new < $largelimit+1)
{
	$bigfield .= newline($games_new) . $output_new . newline($games_new) . linebreak($big); $big++;
}
else
{
	$smallfield .= newline($games_new) . $output_new . newline($games_new) . linebreak($small); $small++;
}

// #########################
// ### most played Games ###
// #########################
if ($games_popular < $largelimit+1)
{
	$bigfield .= newline($games_popular) . $output_popular . newline($games_popular) . linebreak($big); $big++;
}
else
{
	$smallfield .= newline($games_popular) . $output_popular . newline($games_popular) . linebreak($small); $small++;
}

// ########################
// ### best rated Games ###
// ########################
if ($games_rating < $largelimit+1)
{
	$bigfield .= newline($games_rating) . $output_rating . newline($games_rating) . linebreak($big); $big++;
}
else
{
	$smallfield .= newline($games_rating) . $output_rating . newline($games_rating) . linebreak($small); $small++;
}

// ####################
// ### random Games ###
// ####################
if ($games_rand < $largelimit+1)
{
	$bigfield .= newline($games_rand) . $output_random . newline($games_rand) . linebreak($big); $big++;
}
else
{
	$smallfield .= newline($games_rand) . $output_random . newline($games_rand) . linebreak($small); $small++;
}

// ***************************************
// *** construct the final HTML-Output ***
// ***************************************
$output = 	"<table width='100%' border='0' cellspacing='0' cellpadding='1' colspan='".$col."'>\n"
		."<tr>\n"
		.$bigfield
		.$smallfield
		."<tr>\n</table>\n";

// ***************************************
// *** hand everything to the Template ***
// ***************************************
eval('$home["$mods[modid]"][\'content\'] = "' . fetch_template('adv_portal_ibproarcade') . '";');

// ***************************
// *** wipe everything out ***
// ***************************
$output		= NULL;
$output_new	= NULL;
$output_popular	= NULL;
$output_rating	= NULL;
$output_random	= NULL;
$bigfield	= NULL;
$smallfield	= NULL;

// ###############################
// ### END OF EXECUTIVE SCRIPT ###
// ###############################

// **********************
// *** some functions ***
// **********************
function getgames($method, $limit, $title)
{
	global $vbulletin, $path, $largelimit, $db;

	$game_info_gid 		= array();
	$game_info_gname	= array();
	$game_info_gtitle	= array();
	$game_info_gwords	= array();

	switch ($method)
	{
		case 2:
	        	$orderby = 'gcount DESC';
	        	break;
		case 3:
	        	$orderby = 'g_rating DESC';
		        break;
		case 4:
	        	$orderby = 'RAND()';
		        break;
		default:
		        $orderby = 'gid DESC';
	}

	for ($x = 0 ; $x < $limit ; $x++)
	{
		$game = $db->query("	SELECT g.gid, g.gname, g.gcount, g.gtitle, g.g_rating, g.gwords
					FROM " . TABLE_PREFIX . "games_list AS g, " . TABLE_PREFIX . "games_cats AS c
					WHERE g.active='1' AND g.gcat=c.c_id AND c.password=''
					ORDER BY ".$orderby."
					LIMIT ".$limit
					);

		while($info = $db->fetch_array($game))
		{
			array_push($game_info_gid, 	$info['gid']);
			array_push($game_info_gname, 	$info['gname']);
			array_push($game_info_gtitle,	$info['gtitle']);
			array_push($game_info_gwords,	$info['gwords']);
		}
	}

	$db->free_result($game);

	$out 		 = "";

	$out 		.= "<td valign='top'>";
	$out		.= "<fieldset class='fieldset'>\n<legend>".$title."</legend>\n";

	$imagename 	= "1.gif";
	if ($limit > $largelimit) { $imagename = "2.gif"; }

	for ($x = 0 ; $x < $limit ; $x++)
	{
		$mouseover	= $game_info_gtitle[$x];
		$moretext	= $game_info_gwords[$x];
		$strong_on	= "<strong>";
		$strong_off	= "</strong>";

		if ($limit > $largelimit)
		{
			$mouseover = $game_info_gwords[$x];
			$moretext  = "";
			$strong_on = "";
			$strong_off= "";
		}

		$out .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
		$out .= "	  <tr>\n";
		$out .= "	    <td width='1%' valign='top' class='alt1'><div align='center'><a href='".$vbulletin->options['bburl']."/arcade.php?act=Arcade&do=play&gameid=".$game_info_gid[$x]."' target='_self'><img src='".$path.$game_info_gname[$x].$imagename."' border='0' alt='".$mouseover."'></a></div></td>\n";
		$out .= "		<td width='99%' class='alt1'>\n";
		$out .= "		<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
		$out .= "          <tr>\n";
		$out .= "            <td><a href='".$vbulletin->options['bburl']."/arcade.php?act=Arcade&do=play&gameid=".$game_info_gid[$x]."' target='_self'>".$strong_on.$game_info_gtitle[$x].$strong_off."</a></td>\n";
		$out .= "          </tr>\n";
		$out .= "          <tr>\n";
		$out .= "            <td><span class='smallfont'>".$moretext."</span></td>\n";
		$out .= "          </tr>\n";
		$out .= "        </table>\n";
		$out .= "		</td>\n";
		$out .= "	  </tr>\n";
		$out .= "\n";
		$out .= "</table>\n";
	}

	$out .= "</fieldset>\n";
	$out .= "</td>\n";

	return $out;
}

function getscores($method,$title,$limit)
{
	global $vbulletin, $path, $phrase1, $phrase2, $db;

	$out 		.= "<td valign='top'>";
	$out		.= "<fieldset class='fieldset'>\n<legend>".$title."</legend>\n";

	switch ($method)
	{
		case 1: // Top Highscore-Champions
			$result = $db->query("	SELECT champ_gid AS gid, champ_mid AS userid, champ_name AS name, COUNT(champ_mid) AS total
				  		FROM " . TABLE_PREFIX . "games_champs
				  		GROUP BY userid
				  		ORDER BY total DESC LIMIT ".$limit);
			$counter=1;
			while($champ = $db->fetch_array($result))
			{
				$smily = "&nbsp;";
				if ($counter == 1) { $smily = "<img src='".$path."1st.gif' border='0' alt='1' />"; }
				if ($counter == 2) { $smily = "<img src='".$path."2nd.gif' border='0' alt='2' />"; }
				if ($counter == 3) { $smily = "<img src='".$path."3rd.gif' border='0' alt='3' />"; }
				if ($counter > 3 ) { $smily = "<i>".$counter.".</i>"; }
				$counter++;

				$out .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
				$out .= "	  <tr>\n";
				$out .= "		<td width='10%' class='alt1'>\n";
				$out .= "		".$smily;
				$out .= "		</td>\n";
				$out .= "		<td width='90%' class='alt1'>\n";
				$out .= "		<strong>".$champ['name']."</strong>&nbsp;(".$champ['total'].")\n";
				$out .= "		</td>\n";
				$out .= "	  </tr>\n";
				$out .= "</table>\n";
			}
	        	break;
		case 2: // latest Champions
			$result = $db->query("	SELECT c.*, g.gcat, cat.password
						FROM " . TABLE_PREFIX . "games_champs AS c, " . TABLE_PREFIX . "games_list AS g, " . TABLE_PREFIX . "games_cats AS cat
						WHERE c.champ_gid=g.gid AND g.gcat=cat.c_id AND cat.password=''
						ORDER BY champ_date DESC LIMIT 0,".$limit);
			while ($champ = $db->fetch_array($result))
			{
				$phrase = $phrase2;
				$phrase = preg_replace("/<%NAME%>/i","<strong>".$champ['champ_name']."</strong>",$phrase);
				$phrase = preg_replace("/<%GAME%>/i","<b><i>".$champ['champ_gtitle']."</i></b>",$phrase);

				$out .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
				$out .= "	  <tr>\n";
				$out .= "		<td width='60%' class='alt1' align='left'>\n";
				$out .= "		".$phrase."\n";
				$out .= "		</td>\n";
				$out .= "		<td width='40%' class='alt1' align='right'>\n";
				$out .= "		<i>".vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'],$champ['champ_date'])."</i>\n";
				$out .= "		</td>\n";
				$out .= "	  </tr>\n";
				$out .= "</table>\n";
			}
		        break;
		case 3: // latest Scores
			$result = $db->query("	SELECT s.*, g.gcat, g.gtitle, cat.password
						FROM " . TABLE_PREFIX . "games_scores AS s, " . TABLE_PREFIX . "games_list AS g, " . TABLE_PREFIX . "games_cats AS cat
						WHERE s.gid=g.gid AND g.gcat=cat.c_id AND cat.password=''
						ORDER BY datescored DESC LIMIT 0,".$limit);
			while ($score = $db->fetch_array($result))
			{
				$phrase = $phrase1;
				$phrase = preg_replace("/<%NAME%>/i","<strong>".$score['name']."</strong>",$phrase);
				$phrase = preg_replace("/<%SCORE%>/i","<b><i>".$score['score']."</i></b>",$phrase);
				$phrase = preg_replace("/<%GAME%>/i","<b><i>".$score['gtitle']."</i></b>",$phrase);

				$out .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
				$out .= "	  <tr>\n";
				$out .= "		<td width='60%' class='alt1' align='left'>\n";
				$out .= "		".$phrase."\n";
				$out .= "		</td>\n";
				$out .= "		<td width='40%' class='alt1' align='right'>\n";
				$out .= "		<i>".vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'],$score['datescored'])."</i>\n";
				$out .= "		</td>\n";
				$out .= "	  </tr>\n";
				$out .= "</table>\n";
			}
			break;
	}

	$out .= "</fieldset>\n";
	$out .= "</td>\n";

	return $out;
}

function newline($amount)
{
	global $largelimit;

	$data = "</table>\n<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
	if ($amount > $largelimit)
	{
		$data = "";
	}
	return $data;
}

function linebreak($line)
{
	global $maxcolumns;

	$data = "";
	if (($line/$maxcolumns) == floor($line/$maxcolumns))
	{
		$data = "</table>\n<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
	}
	return $data;
}

// ************************
// *** END OF FUNCTIONS ***
// ************************

?>
